import React, { Fragment } from 'react';
import Modal from '@material-ui/core/Modal';
import Radio from '@material-ui/core/Radio';
import RadioGroup from '@material-ui/core/RadioGroup';
import FormControlLabel from '@material-ui/core/FormControlLabel';
import fillTemplate from 'es6-dynamic-template';
import { VERSION_STABLE, VERSION_BETA } from 'library/headset/consts';
import StyledButton from 'components/StyledButton';
import useStyles from './styles';

type Props = {
    open: boolean,
    strings: object,
    fwInstallVersion: string,
    latestFwVersion: string,
    superUserFWUrls: Array<string>,
    hasBetaVersion: boolean,
    hasAdditionalVersion: boolean,
    betaVersion: string,
    betaBuildNumber: string,
    onClose: () => {},
    onVersionChange: () => {},
    closeChooseVersion: () => {},
    onChooseVersion: () => {}
};

function ChooseVersionModal({
    open,
    strings,
    fwInstallVersion,
    latestFwVersion,
    superUserFWUrls,
    hasBetaVersion,
    betaVersion,
    betaBuildNumber,
    hasAdditionalVersion,
    onClose,
    onVersionChange,
    closeChooseVersion,
    onChooseVersion
}: Props) {
    const classes = useStyles();
    return (
        <Modal open={open} onClose={onClose}>
            <div className={classes.modalContainer}>
                <div className={classes.modalTitle}>
                    {strings.update_device_firmware_selection_modal_title}
                </div>
                <div className={classes.modalVersionsContainer}>
                    <RadioGroup
                        name="version"
                        value={fwInstallVersion}
                        onChange={onVersionChange}
                    >
                        {hasBetaVersion && (
                            <FormControlLabel
                                value={VERSION_BETA}
                                control={
                                    <Radio
                                        color="primary"
                                        classes={{
                                            root: classes.versionRadioOption,
                                            checked:
                                                classes.versionRadioOptionChecked
                                        }}
                                    />
                                }
                                label={fillTemplate(
                                    strings.update_device_firmware_selection_beta_version,
                                    { betaVersion, betaBuildNumber }
                                )}
                            />
                        )}
                        <FormControlLabel
                            value={VERSION_STABLE}
                            control={
                                <Radio
                                    color="primary"
                                    classes={{
                                        root: classes.versionRadioOption,
                                        checked:
                                            classes.versionRadioOptionChecked
                                    }}
                                />
                            }
                            label={fillTemplate(
                                strings.update_device_firmware_selection_latest_version,
                                { version: latestFwVersion }
                            )}
                        />
                        {hasAdditionalVersion && (
                            <Fragment>
                                {superUserFWUrls.map(item => (
                                    <FormControlLabel
                                        key={item.fw_version}
                                        value={item.fw_version}
                                        control={
                                            <Radio
                                                color="primary"
                                                classes={{
                                                    root:
                                                        classes.versionRadioOption,
                                                    checked:
                                                        classes.versionRadioOptionChecked
                                                }}
                                            />
                                        }
                                        label={fillTemplate(
                                            strings.update_device_firmware_selection_custom_version,
                                            { version: item.fw_version }
                                        )}
                                    />
                                ))}
                            </Fragment>
                        )}
                    </RadioGroup>
                </div>
                <div className={classes.modalButtonContainer}>
                    <StyledButton
                        variant="outlined"
                        btnSize="small"
                        onClick={closeChooseVersion}
                    >
                        {strings.button_cancel}
                    </StyledButton>
                    <StyledButton
                        variant="contained"
                        btnSize="small"
                        onClick={onChooseVersion}
                        styles={classes.installButton}
                    >
                        {strings.button_install}
                    </StyledButton>
                </div>
            </div>
        </Modal>
    );
}

export default ChooseVersionModal;
